const bcrypt = require('bcrypt');
const db = require('../helpers/DbHelper');

// Função para autenticar o usuário
async function authenticateUser(req, res) {
  const { username, password } = req.body;

  try {
    const user = await db.findUser(username);

    if (user.length === 0) {
      return res.status(401).json({ message: 'Usuário não encontrado' });
    }

    const match = await bcrypt.compare(password, user.passwordHash);

    if (match) {
      return res.status(200).json({ message: 'Login bem-sucedido' });
    } else {
      return res.status(401).json({ message: 'Credenciais inválidas' });
    }
  } catch (error) {
    console.error('Erro durante a autenticação do módulo adicional');
    return res.status(500).json({ message: 'Erro durante a autenticação' });
  }
}

module.exports = {
  authenticateUser,
};
