const controllers = {}

//import model and sequalize

var sequelize = require('../model/database');
var gpt = require('../model/GPT');
const GPTHelper = require('../helpers/GPTHelper');
sequelize.sync();

controllers.list = async (req, res) => {
    const data = await gpt.findAll()
    .then(function(data){
        GPTHelper.updateGPT();
        return data;
    })
    .catch(error => {
        return error;
    })

    res.json({
        success: true,
        data: data
    });
}

controllers.create = async(req, res) => {
    const {status, msgFrom} = req.body;

    const data = await gpt.create({
        status:status,
        msgFrom:msgFrom
    })
    .then(function(data){
        return data;
    })
    .catch(error=>{
        console.log(error);
        return error;
    })

    res.status(200).json({
        success: true,
        message: "GPT setado com sucesso.",
        data: data
    })
}

controllers.get = async(req, res) => {
    const { id } = req.params;

    const data  = await gpt.findAll({
        where: {id : id}
    })
    .then(function(data){
        return data;
    })
    .catch(error=>{
        console.log(error);
        return error;
    })

    res.json({
        success:true,
        data: data
    })
}

controllers.update = async (req,res) => {
    // parameter get id
    const { id } = req.params;
    // parameter POST
    const {status, msgFrom } = req.body;
    // Update data
    const data = await gpt.update({
        status:status,
        msgFrom:msgFrom
    },
    {
      where: { id: id}
    })
    .then( function(data){
      return data;
    })
    .catch(error => {
      return error;
    }) 
    res.json({success:true, data:data, message:"GPT atualizado com sucesso"});
  }

  controllers.delete = async (req, res) => {
    // parameter post
    const { id } = req.body;
    // delete sequelize
    const del = await gpt.destroy({
      where: { id: id}
    })
    res.json({success:true,deleted:del,message:"GPT apagado com sucesso."});
  }

module.exports = controllers;