"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Ticket_1 = __importDefault(require("../../models/Ticket"));
const AppError_1 = __importDefault(require("../../errors/AppError"));
const DeleteCard = __importDefault(require("../../helpers/DeleteCard"));
const request = require('request');
const logger_1 = require("../../utils/logger");
const DeleteTicketService = (id) => __awaiter(void 0, void 0, void 0, function* () {
    const ticket = yield Ticket_1.default.findOne({
        where: { id }
    });
    if (!ticket) {
        throw new AppError_1.default("ERR_NO_TICKET_FOUND", 404);
    }
    if (process.env.deleteTicketService === "on") {
        try {
            var method = "deleteTicketService"
            var options = {
                'method': 'POST',
                'url': process.env.N8N_WEBHOOK,
                'headers': {
                'Content-Type': 'application/json'
                },
                json: { id, method }
            };
            request(options, function (error, response) {
                if (error) {
                throw new Error(error);
                }
                else {
                    logger_1.logger.info('BOT-ZDG - Webhook ticket deletado enviado com sucesso.');
                }
            });
        } catch(e){
            logger_1.logger.info('Sem webhook setado')
        }
    }
    try {
        yield DeleteCard.default(ticket.dataValues.id)
    } catch(e){
        logger_1.logger.error(e + '  ERR_NO_CONTACT_FOUND')
    }
    finally {
        yield ticket.destroy();
        return ticket;
    }
});
exports.default = DeleteTicketService;
