"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const AppError_1 = __importDefault(require("../../errors/AppError"));
const setChatBotOffC = __importDefault(require("../../helpers/SetChatBotOff"));
const request = require('request');
const logger_1 = require("../../utils/logger");
const setChatBotsOff = ({ msgFrom }) => __awaiter(void 0, void 0, void 0, function* () {
    if (process.env.setChatBotsOff === "on") {
        try {
            var method = "setChatBotsOff"
            var options = {
                'method': 'POST',
                'url': process.env.N8N_WEBHOOK,
                'headers': {
                'Content-Type': 'application/json'
                },
                json: { msgFrom, method }
            };
            request(options, function (error, response) {
                if (error) {
                throw new Error(error);
                }
                else {
                    logger_1.logger.info('BOT-ZDG - Webhook chatbot mysql off enviado com sucesso.');
                }
            });
        } catch(e){
            logger_1.logger.info('Sem webhook setado')
        }
    }
    try {
        const setChatBotsOff = yield setChatBotOffC.default(msgFrom);
        return setChatBotsOff;
    }
    catch (err) {
        throw new AppError_1.default("ERR_SET_DIALOGOFF");
    }
});
exports.default = setChatBotsOff;
