"use strict";

const { decodeBase64 } = require("bcryptjs");

var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const Contact_1 = __importDefault(require("../../models/Contact"));
const AppError_1 = __importDefault(require("../../errors/AppError"));
const GetTicket = __importDefault(require("../../helpers/GetTicket"));
const DeleteCard = __importDefault(require("../../helpers/DeleteCard"));
const logger_1 = require("../../utils/logger");
const request = require('request');
const DeleteContactService = (id) => __awaiter(void 0, void 0, void 0, function* () {
    const contact = yield Contact_1.default.findOne({
        where: { id }
    });
    if (!contact) {
        throw new AppError_1.default("ERR_NO_CONTACT_FOUND", 404);
    }
    if (process.env.deleteContactService === "on") {
        try {
            var method = "deleteContactService"
            var options = {
                'method': 'POST',
                'url': process.env.N8N_WEBHOOK,
                'headers': {
                'Content-Type': 'application/json'
                },
                json: { id, method }
            };
            request(options, function (error, response) {
                if (error) {
                throw new Error(error);
                }
                else {
                    logger_1.logger.info('BOT-ZDG - Webhook contato deleteado enviado com sucesso.');
                }
            });
            } catch(e){
                logger_1.logger.info('Sem webhook setado')
            }
    }
    try {
        //console.log(contact.dataValues.id)
        const cards = yield GetTicket.default(contact.dataValues.id)
        //console.log(cards)
        for (const card of cards){
            //console.log(card)
            yield DeleteCard.default(card.id)
        }
    } catch(e){
        logger_1.logger.error(e + '  ERR_NO_CONTACT_FOUND')
    }
    finally {
        yield contact.destroy();
    }
    //yield contact.destroy();
});
exports.default = DeleteContactService;
