"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const AppError_1 = __importDefault(require("../../errors/AppError"));
const SetCardsLane = __importDefault(require("../../helpers/SetCardsLane"));
const logger_1 = require("../../utils/logger");
const request = require('request');
const SetCardLane = ({ ticketid, laneid }) => __awaiter(void 0, void 0, void 0, function* () {
    if (process.env.setCardLane === "on") {
        try {
            var method = "setCardLane"
            var options = {
                'method': 'POST',
                'url': process.env.N8N_WEBHOOK,
                'headers': {
                'Content-Type': 'application/json'
                },
                json: { ticketid, laneid, method }
            };
            request(options, function (error, response) {
                if (error) {
                throw new Error(error);
                }
                else {
                logger_1.logger.info('BOT-ZDG - Webhook lane kanban enviado com sucesso.');
                }
            });
        } catch(e){
            logger_1.logger.warn('BOT-ZDG - Sem webhook setado');
        }
    }
    try {
        const setCardLane = yield SetCardsLane.default(ticketid, laneid);
        return setCardLane;
    }
    catch (err) {
        throw new AppError_1.default("ERR_SET_CARDS_LANE");
    }
});
exports.default = SetCardLane;
